<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Charger l'autoloader Composer
require_once __DIR__ . '/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\IOFactory;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Définition des chemins
$excelPath    = __DIR__ . '/passphrases.xlsx';
$configPath   = __DIR__ . '/config.json';
$templateFile = __DIR__ . '/email_templates.json';

// Chargement de la configuration SMTP
if (!file_exists($configPath)) {
    die("Le fichier de configuration $configPath est introuvable.");
}
$config = json_decode(file_get_contents($configPath), true);

// Chargement du fichier Excel des passphrases
if (!file_exists($excelPath)) {
    die("Fichier Excel introuvable: $excelPath");
}
try {
    $spreadsheet = IOFactory::load($excelPath);
} catch (\PhpOffice\PhpSpreadsheet\Reader\Exception $e) {
    die("Erreur lors du chargement du fichier Excel: " . $e->getMessage());
}
$sheet = $spreadsheet->getActiveSheet();
$passphrases = [];

// Parcourir les lignes en accédant directement aux cellules (colonne A: passphrase, colonne B: statut)
foreach ($sheet->getRowIterator() as $row) {
    $rowIndex = $row->getRowIndex();
    // Si le fichier contient une ligne d'en-tête, décommentez la ligne suivante :
    // if ($rowIndex == 1) continue;

    $passphrase = $sheet->getCell("A{$rowIndex}")->getValue();
	$status = $sheet->getCell("B{$rowIndex}")->getValue();

		// Vérification si la valeur n'est pas null avant d'appliquer strtolower
		if (!is_null($status)) {
			$status = strtolower($status);
		}

		if (!empty($passphrase)) {
			$passphrases[] = [
				'text' => $passphrase,
				'used' => ($status === 'used')
			];
		}

}

// Chargement des templates d'email
$emailTemplates = [];
if (file_exists($templateFile)) {
    $json = file_get_contents($templateFile);
    $emailTemplates = json_decode($json, true);
    if (!is_array($emailTemplates)) {
        $emailTemplates = [];
    }
}

// Générer le QR code si le formulaire de génération a été soumis
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['passphrase']) && !empty($_POST['passphrase']) && isset($_POST['generate_qr'])) {
    $selectedPassphrase = trim($_POST['passphrase']);

    // Créer le dossier pour stocker les QR codes s'il n'existe pas
    $qrDir = __DIR__ . '/qrcodes/';
    if (!is_dir($qrDir)) {
        mkdir($qrDir, 0755, true);
    }
    $qrFileName = md5($selectedPassphrase) . '.png';
    $qrPath = $qrDir . $qrFileName;

    // Générer le QR code via qrencode (assurez-vous que le paquet qrencode est installé)
    $command = 'qrencode -o ' . escapeshellarg($qrPath) . ' ' . escapeshellarg($selectedPassphrase);
    exec($command, $output, $return_var);

    // Affichage des informations de débogage
    echo "<pre>Commande exécutée: $command\nCode retour: $return_var\nOutput:\n" . print_r($output, true) . "</pre>";

    if ($return_var === 0 && file_exists($qrPath)) {
        $_SESSION['qr_code'] = $qrPath;
        $_SESSION['passphrase'] = $selectedPassphrase;

        // Marquer la passphrase comme utilisée dans l'Excel
        foreach ($sheet->getRowIterator() as $row) {
            $rowIndex = $row->getRowIndex();
            if ($sheet->getCell("A{$rowIndex}")->getValue() == $selectedPassphrase) {
                $sheet->setCellValue("B{$rowIndex}", 'used');
                break;
            }
        }
        // Sauvegarder les modifications dans le fichier Excel
        $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
        $writer->save($excelPath);
    } else {
        echo "<p>Erreur lors de la génération du QR Code.</p>";
    }
}

// Sauvegarder un template d'email
if (isset($_POST['save_template'])) {
    $templateName    = trim($_POST['template_name'] ?? '');
    $templateContent = trim($_POST['message'] ?? '');
    if (!empty($templateName) && !empty($templateContent)) {
        $emailTemplates[$templateName] = $templateContent;
        file_put_contents($templateFile, json_encode($emailTemplates, JSON_PRETTY_PRINT));
    }
}

// Envoyer l'email
if (isset($_POST['send_email'])) {
    if (empty($_POST['email']) || empty($_POST['subject']) || empty($_POST['message'])) {
        echo "Tous les champs sont requis pour l'envoi de l'email.";
    } else {
        $recipient = filter_var($_POST['email'], FILTER_VALIDATE_EMAIL);
        if (!$recipient) {
            echo "Adresse email invalide.";
        } else {
            $mail = new PHPMailer(true);
            try {
                // Activation du debug SMTP (affichera les échanges SMTP)
                $mail->SMTPDebug = 2;
                $mail->isSMTP();
                $mail->Host       = $config['smtp_host'] ?? '';
                $mail->SMTPAuth   = true;
                $mail->Username   = $config['smtp_user'] ?? '';
                $mail->Password   = $config['smtp_pass'] ?? '';
                $mail->SMTPSecure = $config['smtp_secure'] ?? 'tls';
                $mail->Port       = $config['smtp_port'] ?? 587;

                $mail->setFrom($config['smtp_user'] ?? 'no-reply@example.com', 'DarkTuche Passphrase Sender');
                $mail->addAddress($recipient);
                $mail->Subject = $_POST['subject'];
                $mail->isHTML(true);

                $qrCode = $_SESSION['qr_code'] ?? '';
                // Remplacer le placeholder {{QR_CODE}} par une balise image pointant vers le QR code
                $messageBody = str_replace('{{QR_CODE}}', "<img src='qrcodes/" . basename($qrCode) . "' width='200'>", $_POST['message']);
                $mail->Body = $messageBody;
                $mail->send();
                echo "Email envoyé avec succès.";
            } catch (Exception $e) {
                echo "Erreur lors de l'envoi: " . $mail->ErrorInfo;
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Envoi de Passphrase</title>
  <!-- Lien vers le CSS de Bootstrap -->
  <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background-color: #121212; /* Noir foncé */
      color: #f1f1f1; /* Blanc cassé */
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .container {
      max-width: 800px;
      margin-top: 50px;
    }
    .btn-custom {
      background-color: #f3b632; /* Jaune inspiré de Binance */
      color: #121212;
    }
    .btn-custom:hover {
      background-color: #e3a228; /* Jaune plus foncé */
    }
    h2 {
      color: #f3b632; /* Jaune inspiré de Binance */
    }
    .qr-code img {
      max-width: 100%;
      height: auto;
    }
    .form-group input, .form-group select, .form-group textarea {
      margin-bottom: 10px;
      background-color: #1e1e1e; /* Fond noir */
      color: #f1f1f1;
      border: 1px solid #444;
    }
    .form-group input:focus, .form-group select:focus, .form-group textarea:focus {
      border-color: #f3b632; /* Jaune lors du focus */
    }
    hr {
      margin-top: 30px;
      margin-bottom: 30px;
      border-color: #444;
    }
    .footer {
      text-align: center;
      color: #888;
      margin-top: 50px;
    }
    .footer a {
      color: #f3b632; /* Jaune inspiré de Binance */
    }
    /* Logo */
    .logo {
      max-width: 150px;
      margin: 20px auto;
      display: block;
    }
  </style>
</head>
<body>

<!-- Logo en haut de la page -->
<img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSRC_n5Ab2f8hXHfQALldHaE5cxGm9mBYkVLXu6fqbhgpRt9bRAygZwa6ebiOO-t4ibonY&usqp=CAU" alt="Binance Logo" class="logo">

<div class="container">
  <h2 class="text-center">DarkTuche Passphrases Web3</h2>
  <form method="POST" autocomplete="on">
    <div class="form-group">
      <label for="passphrase">Sélectionner une passphrase</label>
      <select name="passphrase" id="passphrase" class="form-control" required autocomplete="off">
        <option value="">-- Sélectionner une passphrase --</option>
        <?php foreach ($passphrases as $pass): ?>
          <option value="<?php echo htmlspecialchars($pass['text']); ?>" <?php echo $pass['used'] ? 'disabled' : ''; ?>>
            <?php echo htmlspecialchars($pass['text']); ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <button type="submit" name="generate_qr" value="1" class="btn btn-custom btn-block">Générer QR Code</button>
  </form>

  <?php if (isset($_SESSION['qr_code'])): ?>
    <div class="qr-code text-center">
      <h2>QR Code généré</h2>
      <img src="qrcodes/<?php echo basename($_SESSION['qr_code']); ?>" alt="QR Code">
    </div>
    
    <h2>Email</h2>
    <form method="POST" autocomplete="on">
      <div class="form-group">
        <label for="recipient_name">Nom du destinataire</label>
        <input type="text" name="recipient_name" id="recipient_name" class="form-control" placeholder="Nom du destinataire" required autocomplete="off">
      </div>
      <div class="form-group">
        <label for="email">Adresse du destinataire</label>
        <input type="email" name="email" id="email" class="form-control" placeholder="Destinataire" required autocomplete="email">
      </div>
      <div class="form-group">
        <label for="subject">Sujet</label>
        <input type="text" name="subject" class="form-control" placeholder="Sujet" required autocomplete="off">
      </div>
      <div class="form-group">
        <label for="template">Choisir un template</label>
        <select name="template" class="form-control" onchange="document.getElementById('message').value = this.value;">
          <option value="">-- Choisir un template --</option>
          <?php foreach ($emailTemplates as $name => $content): ?>
            <option value="<?php echo htmlspecialchars($content); ?>"><?php echo htmlspecialchars($name); ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="form-group">
        <label for="message">Message</label>
        <textarea name="message" id="message" class="form-control" rows="5" required>{{QR_CODE}} - {{PASS_PHRASE}} - {{NOM_PRENOM}}</textarea>
      </div>
      <button type="submit" name="send_email" class="btn btn-custom btn-block">Envoyer</button>
    </form>

    <hr>

    <h2>Enregistrer un template</h2>
    <form method="POST" autocomplete="on">
      <div class="form-group">
        <label for="template_name">Nom du template</label>
        <input type="text" name="template_name" class="form-control" placeholder="Nom du template" required autocomplete="off">
      </div>
      <div class="form-group">
        <label for="template_content">Contenu du template</label>
        <textarea name="message" id="template_content" class="form-control" rows="5" placeholder="Contenu du template" required autocomplete="off"></textarea>
      </div>
      <button type="submit" name="save_template" class="btn btn-custom btn-block">Enregistrer Template</button>
    </form>
  <?php endif; ?>
</div>

<div class="footer">
  <p>&copy; 2025 <a href="https://www.darktuche.xyz" target="_blank">DarkTuche.xyz</a>. Tous droits réservés.</p>
</div>

<!-- Scripts Bootstrap -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
